#include "Projectile.h"

#include <lib3d/util2d/Texture.h>
#include <stdio.h>

#define SPEED_FACTOR_X 15.0f
#define SPEED_FACTOR_Y 8.0f
//#define SPEED_FACTOR_X 1.0f
//#define SPEED_FACTOR_Y 0.5f

bool Projectile::first_init = true;

Texture *mslTex;

Projectile :: Projectile() {
   setPos(5,5);
   setVelocity(0.2f,0.9f);
   setGravity(0,-0.9f);
   setPlayer(-1);
   setTrailEffectId(-1);
   setR(PROJ_R);

   if (Projectile::first_init) {

      //mslTex = new Texture("data/msl.png");
      //mslTex = new Texture("data/grenade.png");
      mslTex = new Texture("data/circle.tga");
      mslTex->build();
      
      Projectile::first_init = false;
   }
}

Projectile :: ~Projectile() {
}

void Projectile :: update(float dt) {

   float dx,dy;
   
   velx += gravx * dt;
   vely += gravy * dt;

   dx = velx * dt * SPEED_FACTOR_X; 
   dy = vely * dt * SPEED_FACTOR_Y; 
   setPos(posx+dx,posy+dy);

}

void Projectile :: render() {

   float dx = velx;
   float dy = vely;
   normalize(dx,dy);   
   float ang = RToD(atan2(dy,dx));
      
   const float scl = 0.2f;

   glPushMatrix();
   glTranslatef(posx,posy,0);
   glRotatef(ang,0,0,1);
   glColor3f(1,0,0);
   glEnable(GL_BLEND);
   //glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_ALPHA);
   glBlendFunc(GL_ONE,GL_ONE);
   mslTex->begin();
   glBegin(GL_QUADS);
   glTexCoord2f(1,1); glVertex2f(scl,scl);
   glTexCoord2f(0,1); glVertex2f(-scl,scl);
   glTexCoord2f(0,0); glVertex2f(-scl,-scl);
   glTexCoord2f(1,0); glVertex2f(scl,-scl);
   glEnd();
   mslTex->end();
   glPopMatrix();

   
}

void Projectile :: normalize(float &x,float &y) {

   float len = (float) sqrt(x*x+y*y);
   if (len != 0) {
      x /= len;
      y /= len;
   }

}
